/** @file   minigunalien.h
 * @brief   Declaration of MinigunAlien class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MINIGUNALIEN_H
#define H_WWW_MINIGUNALIEN_H

#include "alien.h"

namespace WeWantWar {



/** MinigunAlien represents the alien with minigun.
 *
 * @author      Tomi Lamminsaari
 */
class MinigunAlien : public Alien
{
public:
  ///
  /// Static members
  /// ==============
  
  /** Index of the controlpoint that represents the nose of our gun. */
  static const int GUN_CONTROLPOINT_INDEX;
  
  
  ///
  /// Constructor, destructor
  /// =======================
  
  // class constructor
  MinigunAlien();
  // class destructor
  ~MinigunAlien();
  
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates this alien.
   */
  virtual void update();
  

  /** Kills this alien.
   */
  virtual void kill();
  
  /** Makes sound.
   * @param     id                ID of the sound we should make.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** This alien got hit by given bullet. The bullets can go through the
   * Alien if it was shot by another alien.
   * @param     pB                Pointer to bullet that hit us.
   * @return    'true' if this bullet did hit us. 'false' means it went
   *            through.
   */
  virtual bool hitByBullet( Bullet* pB );
  
  
  ///
  /// Getter methods
  /// ==============
  
  /** Returns the type of this object.
   * @return    GameObject::TYPE_MINIGUNALIEN
   */
  virtual ObjectID::Type objectType() const;
  
  
  
protected:

  /** Sets the correct animation.
   * @param     aAnimId           The id of requested animation
   */
  virtual void setCorrectAnimation( int aAnimId );
  
  /** Shoots.
   */
  virtual void attack();
  

  ///
  /// Members
  /// =======
  
  /** Walking speed of this alien. */
  eng2d::Vec2D  m_speedVec;
};

};  // end of namespace

#endif // MINIGUNALIEN_H

/**
 * Version history
 * ===============
 * $Log: minigunalien.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:05+02  lamminsa
 * Initial revision
 *
 */
 
